#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#
#~	CC6 Generic ATP Makefile	~#
#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#

#refer to this makefiles usage instructions
CC6_ATP_first: CC6_ATP_usage
	

#for debug set to non-empty:
DEBUG = 

#include the platform constant commands and definitions
include $(MF_PATH)CC6_CMDS.inc

#The components makefiles will be included but not their objects will not be built
DEPENDENCIES := $(CC6_GEN_ID) $(VOS_ID) $(FVOS_ID) $(INIT_ID) \
    $(CRYS_ID) $(FLOW_ID) $(KMNG_ID) $(CRYS_KMNG_ID) $(TLK_SCLK_ID) $(TLK_ODRM_ID) $(TLK_CERT_ID) $(NVS_ID) \
    $(SST_ID) $(CRYS_SST_ID) $(MNG_ID) $(EXTAPP_ID) $(WMDRM_ID) $(SHARED_ATP_ID) $(TLK_SCLK_ATP_ID) $(EXTAPP_ATP_ID)

#enable invoking specific targets from the command line (note: incremental)
ifeq ($(CRYS_ATP),true)
	COMPONENTS += $(CRYS_ATP_ID)
endif
ifeq ($(SST_ATP),true)
	COMPONENTS += $(SST_ATP_ID)
endif
ifeq ($(KMNG_ATP),true)
	COMPONENTS += $(KMNG_ATP_ID)
endif
ifeq ($(TLK_ODRM_ATP),true)
	COMPONENTS += $(TLK_ODRM_ATP_ID)
endif
ifeq ($(TLK_SCLK_ATP),true)
	COMPONENTS += $(TLK_SCLK_ATP_ID)
endif
ifeq ($(TLK_CERT_ATP),true)
	COMPONENTS += $(TLK_CERT_ATP_ID)
endif
ifeq ($(MNG_ATP),true)
	COMPONENTS += $(MNG_ATP_ID)
endif
ifeq ($(WMDRM_TST),true)
	COMPONENTS += $(WMDRM_TST_ID)
endif
ifeq ($(MW_ATP),true)
	COMPONENTS += $(MW_ATP_ID)
	DEPENDENCIES += $(CRYS_ATP_ID) $(SST_ATP_ID) $(KMNG_ATP_ID) $(TLK_ODRM_ATP_ID) $(TLK_CERT_ATP_ID) $(MNG_ATP_ID) $(WMDRM_TST_ID) $(TLK_SCLK_ATP_ID) $(EXTAPP_ATP_ID)
endif
#if none selected, build all targets in the project
ifeq ($(COMPONENTS),)
    COMPONENTS = $(CRYS_ATP_ID) $(SST_ATP_ID) $(KMNG_ATP_ID) $(TLK_ODRM_ATP_ID) $(TLK_CERT_ATP_ID) $(MNG_ATP_ID) $(WMDRM_TST_ID) $(MW_ATP_ID) $(TLK_SCLK_ATP_ID) $(EXTAPP_ATP_ID)
endif

COMPONENTS_MF = $(addprefix $(MF_PATH),$(addsuffix .$(MFEXT),$(DEPENDENCIES) $(COMPONENTS)))
include $(COMPONENTS_MF)

ATP_BIN_PREFIX = CC6_
ATP_BIN_SUFFIX = .$(BINEXT)

TARGETS = $(addprefix $(OUT_BIN_PATH)$(ATP_BIN_PREFIX),$(addsuffix $(ATP_BIN_SUFFIX),$(COMPONENTS) ))

COMPONENTS_OBJS = $(addsuffix _OBJECTS_TARGET,$(COMPONENTS) $(SHARED_ATP_ID))

LIB_OBJECTS = $(OUT_LIB_PATH)CC6_$(PROJECT)_LIB.$(LIBEXT)
ifeq  ($(EXTAPP_ATP_ID),EXTAPP_ATP)
	LIB_OBJECTS += $(OUT_LIB_PATH)CC6_EXTAPP_LIB.$(LIBEXT)
endif
CC6_ATP_main: CC6_ATP_debug COMP_debug $(OUT_OBJ_PATH) $(OUT_BIN_PATH) $(TARGETS) $(addsuffix _check,$(TARGETS))
	$(ECHO) $@ STOP.

#for debug set to the wanted component id:
COMP_NAME = 

#dynamically(with auto-var) get atp component objects:
ATP_COMPONENT_STRIPPED = $(subst $(OUT_BIN_PATH)$(ATP_BIN_PREFIX),,$(subst $(ATP_BIN_SUFFIX),,$@))
ATP_COMPONENT_OBJS = $($(ATP_COMPONENT_STRIPPED)_OBJS)
ATP_COMPONENT_MAIN_OBJS = $($(ATP_COMPONENT_STRIPPED)_MAIN_OBJS)
ATP_COMPONENT_USED_OBJS = $($(ATP_COMPONENT_STRIPPED)_USE_OBJS)

#the individual targets do not have prerequisites because ATPs objects are prerequisites to the atp_main
$(OUT_BIN_PATH)$(ATP_BIN_PREFIX)%$(ATP_BIN_SUFFIX): $(COMPONENTS_OBJS)
	$(DEBUG_ECHO) target $@
	$(DEBUG_ECHO) ATP_COMPONENT_STRIPPED $(ATP_COMPONENT_STRIPPED)
	$(DEBUG_ECHO) ATP_COMPONENT_MAIN_OBJS $(ATP_COMPONENT_MAIN_OBJS)
	$(DEBUG_ECHO) ATP_COMPONENT_OBJS $(ATP_COMPONENT_OBJS)
	$(DEBUG_ECHO) ATP_COMPONENT_USED_OBJS $(ATP_COMPONENT_USED_OBJS)
	$(LD) $(GEN_LDFLAGS) $(ATP_COMPONENT_USED_OBJS) $(ATP_COMPONENT_OBJS) $(ATP_COMPONENT_MAIN_OBJS) $(LIB_OBJECTS) $(LDFLAG_OUTPUT) $@

$(OUT_BIN_PATH)$(ATP_BIN_PREFIX)%$(ATP_BIN_SUFFIX)_check: 
	$(CHECK_AUTO_TARGET_COMPLETE)

CC6_ATP_debug: 
	$(ECHO) PROJECT: $(PROJECT)
	$(ECHO) TARGETS: $(TARGETS)
	$(ECHO) COMPONENTS: $(COMPONENTS)
	$(ECHO) DEPENDENCIES: $(DEPENDENCIES)
	$(DEBUG_ECHO) COMPONENTS_MF $(COMPONENTS_MF)

COMP_debug:
	$(DEBUG_ECHO) COMP_NAME $(COMP_NAME)
	$(DEBUG_ECHO) $(COMP_NAME)_API_INCL_PATH $($(COMP_NAME)_API_INCL_PATH)
	$(DEBUG_ECHO) $(COMP_NAME)_INCL_PATHS $($(COMP_NAME)_INCL_PATHS)
	$(DEBUG_ECHO) $(COMP_NAME)_DEPEND_ON_APIS $($(COMP_NAME)_DEPEND_ON_APIS)
	$(DEBUG_ECHO) $(COMP_NAME)_CCFLAGS $($(COMP_NAME)_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJECTS_CCFLAGS $($(COMP_NAME)_OBJECTS_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJS $($(COMP_NAME)_OBJS)

CC6_ATP_clean:
	$(ECHO) Deleting all objects and binaries...
	-@$(RM) $(OUT_OBJ_PATH:/=$(DIR_SEP))*.$(OBJEXT)
	-@$(RM) $(OUT_BIN_PATH:/=$(DIR_SEP))*.$(BINEXT)
	$(ECHO) Done.

$(OUT_OBJ_PATH) $(OUT_LIB_PATH) $(OUT_BIN_PATH):
	-$(MKDIR) $(@:/=$(DIR_SEP))

CC6_ATP_rebuild: CC6_ATP_clean CC6_ATP_main
	

CC6_ATP_usage:
	@echo This makefile should not run on its own.
	@echo It's meant to be used by another makefile for generic ATP build.
